package edu.columbia.cs.itx.dsadmin;

import java.util.*;
import javax.swing.event.TableModelEvent;
import javax.swing.table.*;

import cnrg.itx.ds.*;

public class DSTableModel extends AbstractTableModel {
  final String[] columnNames = {"User ID",
                                "Extension",
                                "Custom Message"};
  Vector users = new Vector();
  int rows = 0;

  public DSTableModel() {
  }

  public int getColumnCount() {
    return columnNames.length;
  }

  public int getRowCount() {
    return users.size();
  }

  public String getColumnName(int col) {
    return columnNames[col];
  }

  public Class getColumnClass(int c) {
    return getValueAt(0, c).getClass();
  }

  public Object getValueAt(int row, int col) {
    UserProperty user = (UserProperty)users.elementAt(row);
    switch (col) {
      case 0: return user.getUserID().toString();
      case 1: return Integer.toString(user.getExtension());
      case 2: return user.getCustomMessage();
      default: return null;
    }
  }

  public void setUsers(Vector users) {
    if (users != null) {
      this.users = users;
      int newRows = users.size() - rows;
      if (rows != 0) {
        fireTableRowsUpdated(0, rows - 1);
      }
      fireTableRowsInserted(rows, newRows - 1);
      rows = users.size();
    }
  }
}

 